<?php 
session_start();
require('../fpdf/fpdf.php');
class PDF_result extends FPDF {
	function __construct ($orientation = 'P', $unit = 'pt', $format = 'A4', $margin = 30) {
		$this->FPDF($orientation, $unit, $format);
		$this->SetTopMargin($margin-10);
		$this->SetLeftMargin($margin);
		$this->SetRightMargin($margin);
		
		$this->SetAutoPageBreak(true, $margin);
	}
	
	function Header () {
		//if($_POST['CmpLogo']=='true')
	     $this->Image('../images/cmplogo.gif',20,5,150,50);
		//if($_POST['PrePrint']=='false')
		//{
		
		$this->SetFont('times', 'B', 20);
		$this->Cell(0, 30, $_SESSION['SESS_CMP'], 0, 1, 'C', false);
		$this->SetFont('times', '', 12);
		$this->Cell(0, 16, $_SESSION['SESS_CMPADD1'], 0, 1, 'C', false);
			$this->Cell(0, 16,$_SESSION['SESS_CMPADD1_1'], 0, 1, 'C', false);
			$this->SetFont('times', '', 12);
			
			
			
		//}
		
}
	
 function Footer()
{
    $this->SetY(-15);
    $this->SetFont('times','I',8);
	 $this->Cell(0,10,'Printed On:'.date('d/m/Y'),0,0,'L');
}

function date_formatc($temp_date)
{
list($year, $month, $day) = explode('-', $temp_date);
return "$day/$month/$year";
}
	
function Generate_Table($con,$billreg,$billdetails,$vchno,$vchtype) {
	//include "db_connect.php";

if($vchtype=='PURCHASE'){
		$sqlv="SELECT * FROM  purcdetails  WHERE  vchno = '$vchno' ORDER BY entryid ";
		}
		else{
			$sqlv="SELECT * FROM  vchdetails WHERE vchno = '$vchno' ORDER BY entryid";		
          }

$bill_res=mysqli_query($con,$sqlv);
	$this->SetY($this->GetY()+20);
	$this->SetFont('times', 'B', 12);
	$this->SetTextColor(0);
	$this->SetFillColor(255,255,255);
	$yH = 20;
	
	$this->Cell(90,$yH,"Details.",0,1,'L');
	
	$this->Cell(90, $yH, "Pay Type", 'TB', 0, 'L', true);
	$this->Cell(90, $yH, "Reference", 'TB', 0, 'R', true);
	$this->Cell(90, $yH, "Amount", 'TB', 1, 'R', true);
	 
	$this->SetFont('times', '');
	//$this->SetFillColor(238);
	//$this->SetLineWidth(0.2);
		$fill = false;
		$x = $this->GetX();
		$y = $this->GetY();
		
	while($row=mysqli_fetch_array($bill_res)) {
		
		$this->Cell(90, $yH, $row['paytype'], 0, 0, 'L', $fill);
		$this->Cell(90, $yH, $row['billno'], 0, 0, 'R', $fill);
		$this->Cell(90, $yH, $row['amount'], 0, 1, 'R', $fill);
		$fill = !$fill;
		

	}
	
	
}


function Generate_Table_Purch($con,$billreg,$billdetails,$vchno,$vchtype,$bookingreg) {
	//include "db_connect.php";

		$sqlv="SELECT paytype,purcdetails.billno,amount,sttime,clgtime,stkm,clgkm,usedby,city,destination,DATE_FORMAT(dutydate,'%d/%m/%Y') as dutydate FROM  purcdetails inner join $bookingreg on purcdetails.billno=bookid  WHERE  vchno = '$vchno' ORDER BY entryid ";


$bill_res=mysqli_query($con,$sqlv);
	$this->SetY($this->GetY()+20);
	$this->SetFont('times', 'B', 12);
	$this->SetTextColor(0);
	$this->SetFillColor(255,255,255);
	$yH = 20;
	
	$this->Cell(90,$yH,"Details.",0,1,'L');
	
	$columnWidth = 60;
	
	$this->Cell($columnWidth-30 , $yH, "BRN", 'TB', 0, 'L', true);
	$this->Cell($columnWidth , $yH, "Book Date", 'TB', 0, 'L', true);
	$this->Cell($columnWidth , $yH, "ST. Time", 'TB', 0, 'L', true);
	$this->Cell($columnWidth , $yH, "CLG. TIME", 'TB', 0, 'L', true);
	$this->Cell($columnWidth-30 , $yH, "ST. KM", 'TB', 0, 'L', true);
	$this->Cell($columnWidth-30 , $yH, "CLG. KM", 'TB', 0, 'L', true);
	$this->Cell($columnWidth , $yH, "GUEST", 'TB', 0, 'L', true);
	$this->Cell($columnWidth , $yH, "LOCATION", 'TB', 0, 'L', true);
	$this->Cell(0 , $yH, "DESTINATION", 'TB', 1, 'L', true);
	//$this->Cell(90, $yH, "Amount", 'TB', 1, 'R', true);
	 
	$this->SetFont('times', '');
	//$this->SetFillColor(238);
	//$this->SetLineWidth(0.2);
		$fill = false;
		$x = $this->GetX();
		$y = $this->GetY();
		
	while($row=mysqli_fetch_array($bill_res)) {
		
		
		$this->Cell($columnWidth-30 , $yH, $row['billno'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth , $yH, $row['dutydate'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth , $yH, $row['sttime'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth , $yH, $row['clgtime'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth-30 , $yH, $row['stkm'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth-30 , $yH, $row['clgkm'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth , $yH, $row['usedby'], 0, 0, 'L', $fill);
		$this->Cell($columnWidth , $yH, $row['city'], 0, 0, 'L', $fill);
		$this->Cell(0 , $yH, $row['destination'], 0, 1, 'L', $fill);
		//$this->Cell(90, $yH, $row['amount'], 0, 1, 'R', $fill);
		$fill = !$fill;
		

	}
	
	
}
	
	
function recurbill_print($con, $billreg,$billdetails,$vchno,$vchtype,$bookingreg)
	{

		if($vchtype=='PURCHASE'){
		$sqlv="SELECT * FROM  purcreg  WHERE vchno = '$vchno' ";
		}
		else{
			$sqlv="SELECT * FROM  vchreg  WHERE vchno = '$vchno' ";		
          }
if(!$billdet_res=mysqli_query($con,$sqlv))

echo mysqli_error($con);

$vchtype_array = array("PURCHASE", "RECEIPT");





while($billdet_res_row = mysqli_fetch_array($billdet_res))
{
	
	$sql_cmp =mysqli_query($con,"Select * from `commst` where compid = '$billdet_res_row[comcode]' ");
$row_cmp = mysqli_fetch_assoc($sql_cmp);
$this->AddPage();
$this->SetFont('times', 'B', 12);

$this->SetY(100);
$start_border=$this->GetY()-20;
$this->SetFont('times', 'B');

$label_width = 70;
$label_value = 180;
$space = 40;

$this->Cell($label_width,16,"$billdet_res_row[vchtype]",0,0,'L');
$this->Cell($label_value,16,': '.$billdet_res_row[vchno],'B',0,'L');	
$this->Cell($space,16,'',0,0,'L');
$this->Cell($label_width,16,'Date',0,0,'L');

$vchdate=date_create($billdet_res_row[vchdate]);
$this->Cell(0,16,': '.date_format($vchdate,"d/m/Y"),'B',1,'L');



$this->Cell($label_width,16,"Ref No.",0,0,'L');
$this->Cell($label_value,16,': '.$billdet_res_row[refno],'B',0,'L');	
$this->Cell($space,16,'',0,0,'L');
$this->Cell($label_width,16,'Ledger',0,0,'L');
$this->Cell(0,16,': '.$row_cmp[name],'B',1,'L');

if ($vchtype=='RECEIPT')
{
$this->Cell($label_width,16,"Cheque No.",0,0,'L');
$this->Cell($label_value,16,': '.$billdet_res_row[bill_no],'B',0,'L');	
$this->Cell($space,16,'',0,0,'L');
$this->Cell($label_width,16,'Cheque Date',0,0,'L');
$date=date_create($billdet_res_row[invdate]);
$this->Cell(0,16,': '.date_format($date,"d/m/Y"),'B',1,'L');
}


if ($vchtype=='PURCHASE')
{
$this->SetX($label_width+$label_value+$space+30);	
$this->Cell($label_width,16,'Basic Amount',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[basic_amount],'B',1,'L');

$this->SetX($label_width+$label_value+$space+30);	
$this->Cell($label_width,16,'Toll Parking',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[toll_park],'B',1,'L');

$this->SetX($label_width+$label_value+$space+30);	
$this->Cell($label_width,16,'Service Tax',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[ser_tax],'B',1,'L');
}


$this->Cell($label_width,16,"Account",0,0,'L');
$this->Cell($label_value,16,': '.$billdet_res_row[account],'B',0,'L');	
$this->Cell($space,16,'',0,0,'L');
if (in_array($vchtype, $vchtype_array))
{
$this->Cell($label_width,16,'Amount',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[dramount],'B',1,'L');
}


$this->Cell($label_width,16,"Against Ref.",0,0,'L');
$this->SetFont('times', '', 10);
$this->MultiCell($label_value,15,$billdet_res_row[agnstref],'B','L');
$this->SetFont('times', 'B');

$this->SetX($label_width+$label_value+$space-10);
if (in_array($vchtype, $vchtype_array))
{
$this->Cell($space,16,'',0,0,'L');	
$this->Cell($label_width,16,'Deduction',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[sortpayment],'B',1,'L');
}
else
$this->Cell($space,16,'',0,1,'L');


if (in_array($vchtype, $vchtype_array))
{
$this->SetX($label_width+$label_value+$space+30);	
$this->Cell($label_width,16,'TDS',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[tdsamt].'      '.$billdet_res_row[cramount],'B',1,'L');
}


$ay=$this->GetY();
$this->Cell($label_width,16,'Narration',0,0,'L');
$this->MultiCell($label_value,16,': '.$billdet_res_row[narration],'B','L');
$by=$this->GetY();

$this->SetXY($label_width+$label_value+$space+30,$ay);
$this->Cell($label_width,16,'Net Amount',0,0,'L');
$this->Cell(0,16,': '.$billdet_res_row[totamount],'B',1,'L');

$this->SetY($by+10);
if ($vchtype=='PURCHASE')
$this->Generate_Table_Purch($con,$billreg,$billdetails,$billdet_res_row['vchno'],$vchtype,$bookingreg);
else
$this->Generate_Table($con,$billreg,$billdetails,$billdet_res_row['vchno'],$vchtype);


$cy=$this->GetY();
	

	
}// while recurbill_print
$this->SetY($cy+80);
$this->SetFont('times', 'B',11);
$this->Cell(50, 13, "Receiver's Signature",0,1,'L');
$this->SetY($cy+80);
$this->SetX(400);
$this->SetFont('times', 'B',10);
$this->MultiCell(0, 10, "Authorised Signatory",0,0,'R');

	}	// function recurbill_print ends
	
	
	function make_border($start_border,$end_border)
	{
		$this->Line(14,$start_border,586,$start_border);
			$this->Line(16,$start_border+2,584,$start_border+2);
			
			
			$this->Line(14,$start_border,14,$end_border); 
			$this->Line(16,$start_border+2,16,$end_border-2); 
			
			
			$this->Line(584,$start_border+2,584,$end_border-2);
			$this->Line(586,$start_border,586,$end_border);
			
			$this->Line(16,$end_border,584,$end_border);
			$this->Line(14,$end_border+2,586,$end_border+2);
		}
	
}//class ends

		
$pdf = new PDF_result();	
$vchno=$_POST['p_vchno'];
$vchtype=$_POST['vchtype'];
include "../db_connect.php";
include '../db_table_select.php';
$pdf->recurbill_print($con, $billreg,$billdetails,$vchno,$vchtype,$bookingreg);




$pdf->Output('invoice.pdf', 'F');



?>