<?php 
session_start();
require('../../fpdf/fpdf.php');

class PDF_result extends FPDF {
	 	var $totalval;
		var $mrpval;
		var $qtyval;
		var $excessval;
		var $getYaxis;
	function __construct ($orientation = 'P', $unit = 'pt', $format = 'A4', $margin = 10) {
		$this->FPDF($orientation, $unit, $format);
		$this->SetTopMargin($margin);
		$this->SetLeftMargin($margin);
		$this->SetRightMargin($margin);
		
		$this->SetAutoPageBreak(true, $margin);
	}
	

	
 function Footer()
{
    //Position at 1.5 cm from bottom
    $this->SetY(-15);
    //Arial italic 8
    $this->SetFont('Arial','I',8);
    //Page number
    $this->Cell(0,10,'This is a computer generated Invoice'."(Page ".$this->PageNo().")",0,0,'C');
}



function numtowords($number){ 
$no = round($number);
//$point = round($number - $no, 2) * 100;
   $hundred = null;
   $digits_1 = strlen($no);
   $i = 0;
   $str = array();
   $words = array('0' => '', '1' => 'One', '2' => 'Two',
    '3' => 'Three', '4' => 'Four', '5' => 'Five', '6' => 'Six',
    '7' => 'Seven', '8' => 'Eight', '9' => 'Nine',
    '10' => 'Ten', '11' => 'Eleven', '12' => 'Twelve',
    '13' => 'Thirteen', '14' => 'Fourteen',
    '15' => 'Fifteen', '16' => 'Sixteen', '17' => 'Seventeen',
    '18' => 'Eighteen', '19' =>'Nineteen', '20' => 'Twenty',
    '30' => 'Thirty', '40' => 'Forty', '50' => 'Fifty',
    '60' => 'Sixty', '70' => 'Seventy',
    '80' => 'Eighty', '90' => 'Ninety');
   $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
   while ($i < $digits_1) {
     $divider = ($i == 2) ? 10 : 100;
     $number = floor($no % $divider);
     $no = floor($no / $divider);
     $i += ($divider == 10) ? 1 : 2;
     if ($number) {
        $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
        $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
        $str [] = ($number < 21) ? $words[$number] .
            " " . $digits[$counter] . $plural . " " . $hundred
            :
            $words[floor($number / 10) * 10]
            . " " . $words[$number % 10] . " "
            . $digits[$counter] . $plural . " " . $hundred;
     } else $str[] = null;
  }
  $str = array_reverse($str);
  $result = implode('', $str);
  
 

    return $result . "Rupees  " ; 
} 


	
function Generate_Table(&$billdet_res_row,$con) {
	$billno=$_POST['orderid'];
	 $this->SetY($this->GetY() + 20);
	
	$bill_res=mysqli_query($con,"SELECT * FROM   pinvoiceregdet WHERE orderid =  '$billno' ORDER BY srno");
	
	$w=array(20,60,100,200,30,40,50,75);
	$this->SetFont('Arial', 'B', 8);
	$this->Cell($w[0], 25, "S.No", '1', 0, 'C');
	$this->Cell($w[1], 25, "STYLE CODE", '1', 0, 'C');
	$this->Cell($w[1], 25, "Product Desp.", '1', 0, 'C');
	$this->Cell($w[1], 25, "SHADE", '1', 0, 'L');
	$this->Cell($w[3], 25, "Size / Qty (Pieces)", '1', 0, 'C');
	$this->Cell($w[5], 25, "QTY", '1', 0, 'C');
	$this->Cell($w[5], 25, "MRP", '1', 0, 'C');
	$this->Cell($w[5], 25, "WSP", '1', 0, 'C');
	$this->Cell($w[6], 25, "Amount", '1', 1, 'C');
	$this->Ln(5);
	 
	$this->SetFont('Arial', '',10);
	$fill = false;
		$x = $this->GetX();
		$y = $this->GetY();
	while($row=mysqli_fetch_array($bill_res)) {
		if($c>600)
		{
			$this->AddPage();
			$this->bill_header($billdet_res_row);
			$c=0;
			$this->SetFont('Arial', 'B', 9);
			$this->Cell($w[0], 25, "SNo", '1', 0, 'C');
			$this->Cell($w[1], 25, "PRODUCT", '1', 0, 'C');
			$this->Cell($w[1], 25, "Product Desp.", '1', 0, 'C');
			$this->Cell($w[1], 25, "SHADE", '1', 0, 'C');
			$this->Cell($w[3], 25, "Size / Qty (Pieces)", '1', 0, 'C');
			$this->Cell($w[5], 25, "QTY", '1', 0, 'C');
			$this->Cell($w[5], 25, "UNIT", '1', 0, 'C');
			$this->Cell($w[5], 25, "RATE", '1', 0, 'C');
			$this->Cell($w[6], 25, "AMOUNT", '1', 1, 'C');
			$this->SetFont('Arial', '');
			$this->Ln(5);
	
		}
			
			$this->SetFont('Arial', '', 9);
			$this->Cell($w[0], 12,$row['srno'], 0, 0, 'L');
			$x = $this->GetX();
			$y1 = $this->GetY();
			$this->MultiCell($w[1], 12, $row['prodcode'],0,'L');	
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($x + $w[1], $this->GetY() - $yH);
			
			
			
			$x = $this->GetX();
			$y1 = $this->GetY();
			$this->MultiCell($w[1], $yH, iconv("UTF-8", "ISO-8859-2", $row['cat']), 0,'L');	
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($x + $w[1], $this->GetY() - $yH);
			
			
			
			$x = $this->GetX();
			$y1 = $this->GetY();
			$this->MultiCell($w[1], $yH, $row['colorcode'],0,'L');	
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($x + $w[1], $this->GetY() - $yH);
			
			$size='';
			$qty ='';
			
			$jobvar_res=mysqli_query($con,"SELECT * FROM   pinvoicevar WHERE job_id =  '$billno' and prodname = '$row[prodcode]' and srno = '$row[srno]'  ORDER BY entryid");
		    while($jobvarrow=mysqli_fetch_array($jobvar_res)) {
			 $size = $this->Cell(8, 0,$jobvarrow['size'], 0, 0, 'L').$size;
			 $qty = $this->Cell(7, 20,$jobvarrow['qnty'], 0, 0, 'L').$qty;
		     }
			 
			 $x = $this->GetX();
			$y1 = $this->GetY();

			$this->Cell($w[3], 30, $size,0,1,'L');	
			//$this->SetX($x-10);
			$this->Cell($w[3], $yH, $qty,0,0,'L');
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($this->GetX()+190, $this->GetY() - $yH);
		
		
		$this->Cell($w[5], $yH, $row['qty'], 0, 0, 'R');
		$this->Cell($w[5], $yH, $row['mrp'], 0, 0, 'R');
		$this->Cell($w[5], $yH, $row['pcost'], 0, 0, 'R');
		$this->Cell($w[6], $yH, $row['pamt'], 0, 1, 'R');
		
		$c=$this->GetY();
		$this->totalval += $row['pamt'];
		$this->mrpval += $row['mrp'];
		$this->qtyval += $row['qty'];
		$this->excessval += $row['qty'] *$row['mrp'];
		$this->Line(10,$this->GetY()-7,580,$this->GetY()-7);
			}
		$y=$this->GetY();
	
	
	$this->bill_footer($billdet_res_row);	
}//end of Generate_Table()	



function bill_header(&$billdet_res_row,$con){
$this->SetFont('Arial', 'B',9);
$headY=$this->GetY();
$this->Cell(0, 10, "Subject to Mumbai Jurisdiction", 0, 1, 'L');
$this->SetFont('Arial', 'B',9);
$this->SetY($headY);
$this->Cell(0, 10, "Extra Copy", 0, 1, 'R');
$this->SetY($headY);
$this->Cell(0, 10, "TAX INVOICE", 0, 1, 'C');
$this->SetFont('Arial', '',9);
$this->Cell(0, 10, "Rule 11 of Central Excise 2002", 0, 1, 'C');




$this->SetFont('Arial', '');
$ty=$this->GetY();
 $this->make_border($this->GetY(),830);	
$txt=	"

  
  
  
		";
		
$this->MultiCell(50, 13, $txt,'LT','L');

$txt=	"$_SESSION[SESS_CMP]
$_SESSION[SESS_CMPADD1]
";

$this->SetXY(60,$ty);
$this->MultiCell(250, 13, $txt,'T','L');


$this->MultiCell(300, 13, "$_SESSION[SESS_CMPADD1_1]",'L','L');


$this->SetFont('Arial', 'B');
$this->Cell(100, 13, "C.Ex.Regn No",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(200, 13, "AAFHR9718HEM003",'T',1);
$this->SetFont('Arial', 'B');
$this->Cell(100, 13, 'Division','L',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(200, 13, "VASAI DIVISION",'R',1 ,'L');	

$this->SetFont('Arial', 'B');
$this->Cell(100, 13, 'Range','L',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(200, 13, "IV OF VASAI I RANGE OF THANE II",'R',1 ,'L');	

$this->SetFont('Arial', 'B');
$this->Cell(100, 13, 'Commissionrate','L',0 ,'L');
$this->SetFont('Arial', 'B');
$this->Cell(200, 13, "THANE-II",'R',1 ,'L');


$this->SetFont('Arial', 'B');
$this->Cell(30, 13, 'Party :','LT',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(270, 13, " $billdet_res_row[name]",'RT',1 ,'L');
	
$this->SetFont('Arial', '');

$party=	"$billdet_res_row[address]";
	
$this->SetFont('Arial', '', 8);		
$this->MultiCell(300, 13, $party,'L','L');	

$this->SetFont('Arial', 'B',9);
$this->Cell(100, 13, 'Tel :','L',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(200, 13, " $billdet_res_row[telephone]",'R',1 ,'L');

$this->SetFont('Arial', '',9);
$this->Cell(60, 13, 'VAT TIN No. :','L',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(240, 13, " $billdet_res_row[cmpvat]",'R',1 ,'L');

$this->SetFont('Arial', '',9);
$this->Cell(60, 13, 'CST TIN No. :','L',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(240, 13, " $billdet_res_row[tin]",'R',1 ,'L');

$this->SetXY(310,$ty);
$txt=	" Pre_Authentication
 For $_SESSION[SESS_CMP]
 
 ";
  
$this->SetFont('Arial', '', 7);
$this->MultiCell(270, 13, $txt,'TR','C');



$this->SetXY(310,$this->GetY());
$this->SetFont('Arial', '', 9);
$this->MultiCell(270, 13, " Authorised Signatory",'R','C');

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "INVOICE No.",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(80, 13, "$billdet_res_row[orderid]",'T',0);
$this->SetFont('Arial', 'B');
$this->Cell(50, 13, 'Date','T',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(70, 13, "$billdet_res_row[orderdate]",'TR',1 ,'L');

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(135, 13, "Date & Time Of Invoice :",'L',0);
$this->SetFont('Arial', '');
$this->Cell(135, 13, "",'R',1);

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(135, 13, "Date & Time Of Goods Removal :",'L',0);
$this->SetFont('Arial', '');
$this->Cell(135, 13, "",'R',1);

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(135, 13, "Tarrif Heading No :",'L',0);
$this->SetFont('Arial', '');
$this->Cell(135, 13, "62034200 , 62652000",'R',1);

$this->SetFont('Arial', '');
$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "Packing Slip No. ",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(80, 13, ": $billdet_res_row[refno]",'T',0);
$this->SetFont('Arial', 'B');
$this->Cell(50, 13, 'Date','T',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(70, 13, ": $billdet_res_row[orderdate]",'TR',1 ,'L');




$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "L.R.No.",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(80, 13, ": $billdet_res_row[lrno]",'T',0);
$this->SetFont('Arial', 'B');
$this->Cell(50, 13, 'Date:','T',0 ,'L');
$this->SetFont('Arial', '');
$this->Cell(70, 13, ": $billdet_res_row[lrdate]",'TR',1 ,'L');

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "Disp. Through",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(200, 13, ": $billdet_res_row[shipvia]" ,'TR',1);

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "Broker",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(200, 13, ": $billdet_res_row[agentcode]" ,'TR',1);

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "Form Type",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(200, 13, ": $billdet_res_row[formtype]",'TR',1);

$this->SetX(310);
$this->SetFont('Arial', 'B');
$this->Cell(70, 13, "Total Parcels",'LT',0);
$this->SetFont('Arial', '');
$this->Cell(200, 13, ": $billdet_res_row[totparcel]",'TR',1);


	$this->line(310,100,310,$this->GetY()+20);
$this->SetFont('Arial', '');
}//end of bill_header()


function bill_footer(&$billdet_res_row){
	$y=550;
	$this->Line(10,$y,580,$y);
	//$this->Line(10,$fotty,10,$this->GetY());
	
	$this->SetY($y);
	
	$this->SetFont('Arial', '', 7);
	$this->Cell(100, 15, "Payment Due Dt :"." ",'L', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'0', 0);
	$this->Cell(100, 15, " "." ",'0', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(100, 15, "DISCOUNTED GOODS"." ",'L', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'0', 0);
	$this->Cell(100, 15, " "." ",'0', 1);
	$this->SetFont('Arial', '');
	
	$exciseval =  $this->excessval;
	$sixtperval = round($exciseval * (60/100));
	$twoperval =  round($sixtperval * (2/100));
	
	$this->SetFont('Arial', '',7);
	$this->Cell(275, 15, "MRP Value of Bill on which Excise is Not Applicable R:"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "."",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(275, 15, "MRP Value of Bill on which Excise is Applicable Rs."." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " ".$exciseval.".00",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(275, 15, "60.00 % of MRP:above Rs.999/-(Assesseble Value)"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " ".$sixtperval.".00",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(275, 15, "B.E.D. 2% ON 60% OF MRP VALUE"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " ".$twoperval.".00",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(110, 15, "Total Excise Amount In Rupees : "." ",'LT', 0);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(460, 15,"(".$this->numtowords($twoperval).")",'RT');
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(100, 15, "Total Invoice Value in Rupees:"." ",'LB', 0);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(470, 15,"(".$this->numtowords($billdet_res_row[grtotal]).")",'RB');
	
	
	
	
	$this->SetFont('Arial', '');
	$this->Cell(570, 13, "* Vide notification no 15/2016 dated 01.03.2016, excise is charged on the goodes having MRP above/equals to Rs.1000/-."." ",'LR', 1);
	
	$this->SetFont('Arial', '');
	$this->MultiCell(570, 10,"Excise Declaration: I/We hereby declare to the best of our knowledge and belief that the particulars stated herein are true and correct and there is no additional consideration accuring to us either or indirectly in any manner other than the amounts indicated here ",'LRB');
	
	
	$term=$this->GetY();
	$this->SetFont('Arial', '');
	$this->MultiCell(285, 9," + Tems & Conditions +
	* Payment for this bill will be accepted only by cross & order draft or cheque only.
	* Goods once sold will be not be taken back.
	* Payment strictly within 30 Days",'LB');
	
	$this->SetXY(295,$term);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(285, 9," Our Bankers : ICICI Bank
	Branch Name : Malad(West), Mumbai
	A/C No. 015805001010
	RTGS/NEFT IFSC : ICIC0000158",'RB', 'C');
	
    $this->SetFont('Arial', 'B', 6);
	$this->MultiCell(570, 6,"Any Disputes or Differences whatsoever arising between the parties relating to this contract shall be subject to jurisdiction of conciliation & arbitration Sub committee for settlement in accordance with rules for conciliation of The clothing manufacturers Association of India and if not Resolved then shall be referred to Arbitration in accordance with the Rules of arbitration of the Indian Merchant Chambers as per MOU between CMAI & IMC and award made in pursuance there of shall be Final and binding on the  parties.\"
	
	\"I/We hereby certify that my/our registration certificate under the Maharashtra Value Added Tax Act 2002 is in Force on the date on which the sale of the goods specified in this tax invoice is made by me/us and that the transaction of sale covered by this tax invoice has been effected by me/us and it is shall be accounted for in turnover of sales while filling of return and the due tax, if any payable on the sale has been paid or shall be paid.\"",'LRB');
	
	
	
	
	
	$t=$this->GetY();
	$this->SetFont('Arial', 'B',9);
	
	$this->SetXY(430,$y);
		
		$this->line(30,250,30,$this->GetY());
		$this->line(90,250,90,$this->GetY());
		$this->line(150,250,150,$this->GetY());
		$this->line(210,250,210,$this->GetY());
		$this->line(410,250,410,$this->GetY());
		$this->line(450,250,450,$this->GetY());
		$this->line(490,250,490,$this->GetY());
		$this->line(530,250,530,$this->GetY());
		
	$this->Cell(50, 15, "Total",0, 0);
	$this->Cell(50, 15, "",0, 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row[ptotal], 0, 1, 'R');
	$this->SetFont('Arial', '');
	
	
	if(!empty($billdet_res_row['pdiscount'])||$billdet_res_row['pdiscount']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "Discount ".$billdet_res_row['pdiscount']."%", 0);
	$this->Cell(50, 15,$billdet_res_row[ptotal], 0,0,'R');
	$this->SetFont('Arial', 'B');
	
	$this->Cell(50, 15, $billdet_res_row[disamt], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}
	
	if(!empty($billdet_res_row['vat'])||$billdet_res_row['vat']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "Vat 6% ", 0);
	$this->Cell(50, 15, $billdet_res_row[ptotal], 0,'R');
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row['vat'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}
	
	/*if(!empty($billdet_res_row['sevta'])||$billdet_res_row['sevta']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "SevT", 0);
	$this->Cell(50, 15, $billdet_res_row['sevtr']."%", 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row['sevta'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}*/

	/*if(!empty($billdet_res_row['extraa'])||$billdet_res_row['extraa']!='0.00'){
		$this->SetX(430);
		$this->Cell(50, 15, $billdet_res_row['extra'], 0);
		$this->Cell(50, 15, $billdet_res_row['extrar']."%", 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(50, 15, $billdet_res_row['extraa'], 0, 1, 'R');
		$this->SetFont('Arial', '');
		}*/
		
		$this->SetX(430);
		$this->Cell(50, 15, "Grand Total",'TB', 0);
		$this->Cell(50, 15, "",'TB', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(50, 15, $billdet_res_row[grtotal], 'TB', 1, 'R');
		$this->SetFont('Arial', '');

		$this->SetFont('Arial', '',7);
		$this->SetY($t);
		$t=$this->GetY();
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "VAT TIN No.:",'TL', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(200, 15, "27740027477V .w.e.f.01.04.2006",'', 0);
		$this->Cell(130, 15, " ",'', 0);
		$this->Cell(170, 15, "From $_SESSION[SESS_CMP]",'LR', 1);
		$this->SetFont('Arial', '');
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "CST TIN No.:",'L', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(200, 15, "27740027477VC w.e.f.01.04.2006",'', 0);
		$this->Cell(130, 15, " ",'', 0);
		$this->Cell(170, 15, " ",'LR', 1);
		
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "CIN No.",'BL', 0);
		$this->SetFont('Arial', '',7);
		$this->Cell(200, 15, " ",'B', 0);
		$this->Cell(130, 15, "Receiver Signature [With Rubber Stamp]",'TB','C', 0);
		$this->SetFont('Arial', '',8);
		$this->Cell(170, 15, "Authorised Signatory.",'LBR', 1);
		$this->SetFont('Arial', '');
		
		//$this->SetY($t+10);
		
	$this->make_border($start_border,$end_border);
		//$this->Line(10,800,590,800);
		//$this->Line(10,802,590,802);
		//$this->SetY(810);
		//$this->Cell(75, 15, 'Prepared By:');
		//$this->Cell(350, 15, $billdet_res_row['prepby'],0,0,'L');
		//$this->Cell(75, 15, 'Checked By');
		//$this->Cell(0, 15, $billdet_res_row['checkby'],0,0,'L');
		//$this->Cell(0, 15, "SUBJECT TO MUMBAI JURISDICTION",0,0,'C');
	}// end of bill_footer()


	
	function make_border($start_border,$end_border)
	{
		$this->Line(10,$start_border,580,$start_border);
			//$this->Line(16,$start_border,584,$start_border);
			
			
			$this->Line(10,$start_border,10,$end_border-5); 
			//$this->Line(16,$start_border,16,$end_border); 
			
			
			$this->Line(580,$start_border,580,$end_border-5);
			//$this->Line(586,$start_border,586,$end_border);
			
			$this->Line(10,$end_border-5,580,$end_border-5);
			//$this->Line(10,$end_border,586,$end_border);
		}

}//end of class


$pdf = new PDF_result();
$pdf->AddPage();


$billno=$_POST['orderid'];
include '../../db_connect.php';
	//to select the company's table in current session
include '../../db_table_select.php';


$billdet_res=mysqli_query($con,"SELECT `orderid`,   DATE_FORMAT(`orderdate`,'%d/%m/%Y') as `orderdate`, `ordertype`, `buyercode`, `billedto`, `refno`,  DATE_FORMAT(`dlvdate`,'%d/%m/%Y') as `dlvdate`, `ratetype`, `shipto`, `agentcode`, `distr`, `shipvia`, `shippingpaid`, `totparcel`, `formtype`, `lrno`, DATE_FORMAT(`lrdate`,'%d/%m/%Y') as `lrdate`,`comm`, `comm_on`, `notes`, pinvoicereg.`vat` as vat ,`packinglistno`,disamt, `ptotal`, `pdiscount`, `pnamount`,  `grtotal`, `status`, commst.name, commst.address, commst.vat as cmpvat , commst.tin, commst.telephone
FROM  pinvoicereg INNER JOIN commst ON buyercode=compid 
WHERE orderid = '$billno'");

$billdet_res_row=mysqli_fetch_assoc($billdet_res);
$pdf->SetFont('Arial', 'B', 10);
$pdf->bill_header($billdet_res_row,$con);
	
$pdf->Generate_Table($billdet_res_row,$con);	
$pdf->Output('pinvoice_entry.pdf', 'F');



?>
