<?php 
session_start();
require('../../fpdf/fpdf.php');

class PDF_result extends FPDF {
	function __construct ($orientation = 'P', $unit = 'pt', $format = 'A4', $margin = 10) {
		$this->FPDF($orientation, $unit, $format);
		$this->SetTopMargin($margin);
		$this->SetLeftMargin($margin);
		$this->SetRightMargin($margin);
		
		$this->SetAutoPageBreak(true, $margin);
	}
	

	
 function Footer()
{
    //Position at 1.5 cm from bottom
    $this->SetY(-15);
    //Arial italic 8
    $this->SetFont('Arial','I',8);
    //Page number
    $this->Cell(0,10,'This is a computer generated Invoice'."(Page ".$this->PageNo().")",0,0,'C');
}

	
function Generate_Table(&$billdet_res_row,$con) {
	$billno=$_POST['jobid'];

	//echo $billno;
	$bill_res=mysqli_query($con,"SELECT * FROM   jobregdet WHERE jobid =  '$billno' ORDER BY srno");
	
	$w=array(30,75,100,345,30,40,45,75);
	$this->SetFont('Arial', 'B', 8);
	//$this->Cell($w[0], 25, "Job Card", '1', 0, 'L');
			$this->Cell($w[1], 25, "Product", '1', 0, 'L');
			//$this->Cell($w[2], 25, "Style", '1', 0, 'L');
			$this->Cell($w[3], 25, "Size wise Details", '1', 0, 'C');
			$this->Cell($w[4], 25, "Rcv Qty", '1', 0, 'C');
			//$this->Cell($w[5], 25, "Shortage", '1', 0, 'R');
			$this->Cell($w[6], 25, "Job Rate", '1', 0, 'R');
			$this->Cell($w[7], 25, "Job Amt", '1', 1, 'R');
	$this->Ln(5);
	 
	$this->SetFont('Arial', '',10);
	$fill = false;
		$x = $this->GetX();
		$y = $this->GetY();
	while($row=mysqli_fetch_array($bill_res)) {
		
		
		 
		if($c>600)
		{
			$this->AddPage();
			$this->bill_header($billdet_res_row);
			$c=0;
			$this->SetFont('Arial', '', 9);
			//$this->Cell($w[0], 25, "Job Card", '1', 0, 'L');
			$this->Cell($w[1], 25, "Product", '1', 0, 'L');
			//$this->Cell($w[2], 25, "Style", '1', 0, 'L');
			$this->Cell($w[3], 25, "Size wise Details", '1', 0, 'C');
			$this->Cell($w[4], 25, "Rcv Qty", '1', 0, 'R');
			//$this->Cell($w[5], 25, "Shortage", '1', 0, 'R');
			$this->Cell($w[6], 25, "Job Rate", '1', 0, 'R');
			$this->Cell($w[7], 25, "Job Amt", '1', 1, 'R');
			$this->SetFont('Arial', '');
			$this->Ln(5);
	
		}
			
			$this->SetFont('Arial', '', 9);
			//$this->Cell($w[0], 12,$row['srno'], 0, 0, 'L');
			$x = $this->GetX();
			$y1 = $this->GetY();
			$this->MultiCell($w[1], 12, $row['prodcode'],0,'L');	
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($x + $w[1], $this->GetY() - $yH);
			
			
			
			/*$x = $this->GetX();
			$y1 = $this->GetY();
			$this->MultiCell($w[1], $yH,  $row['colorcode'], 0,'L');	
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY($x + $w[1], $this->GetY() - $yH);*/
			
			$size='';
			$qty ='';
			
			$jobvar_res=mysqli_query($con,"SELECT * FROM   jobvar WHERE job_id =  '$billno' and prodname = '$row[prodcode]'  ORDER BY entryid");
		    while($jobvarrow=mysqli_fetch_array($jobvar_res)) {
			 $size = $this->Cell(10, 0,$jobvarrow['size'], 0, 0, 'L').$size;
			 $qty = $this->Cell(10, 20,$jobvarrow['qnty'], 0, 0, 'L').$qty;
		     }
			
			$x = $this->GetX();
			$y1 = $this->GetY();

			$this->Cell($w[3], 30, $size,0,1,'L');	
			$this->Cell($w[3], $yH, $qty,0,0,'L');
			$y2 = $this->GetY();
			$yH = $y2 - $y1;
			$this->SetXY(($w[3])+70, $this->GetY() - $yH);
		
		
		$this->Cell($w[4], $yH, $row['qty'], 0, 0, 'R');
		$this->Cell($w[6], $yH, $row['pcost'], 0, 0, 'R');
		$this->Cell($w[7], $yH, $row['pamt'], 0, 1, 'R');
		$c=$this->GetY();
			}
	$y=$this->GetY();
	
	
	$this->bill_footer($billdet_res_row);	
}//end of Generate_Table()	



function bill_header(&$billdet_res_row,$con){

$this->SetFont('Arial', '');
$ty=$this->GetY();
$this->make_border($this->GetY(),830);	

		


$this->SetXY(60,$ty);
$this->MultiCell(250, 13, $txt,'T','L');


$this->MultiCell(300, 13, "",'L','L');

$this->SetFont('Arial', 'B');

$this->SetXY(310,$ty);

  
$this->SetFont('Arial', '', 7);
$this->MultiCell(270, 13, $txt,'TR','C');

$this->SetXY(310,$this->GetY());
$this->SetFont('Arial', '', 9);
$this->MultiCell(270, 13, " ",'R','C');






	
$this->SetFont('Arial', '');
}//end of bill_header()


function bill_footer(&$billdet_res_row){
	$y=550;
	$this->Line(10,$y,580,$y);
	//$this->Line(10,$fotty,10,$this->GetY());
	
	$this->SetY($y);
	
	$this->SetFont('Arial', '', 7);
	$this->Cell(100, 15, "Payment Due Dt :"." ",'L', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'0', 0);
	$this->Cell(100, 15, "Total"." ",'0', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(100, 15, "DISCOUNTED GOODS"." ",'L', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'0', 0);
	$this->Cell(100, 15, " "." ",'0', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(175, 15, "MRP Value of Bill on which Excise is Not Applicable R:"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'1', 0);
	$this->Cell(100, 15, " "." ",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(175, 15, "MRP Value of Bill on which Excise is Applicable Rs."." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'1', 0);
	$this->Cell(100, 15, " "." ",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(175, 15, "60.00 % of MRP:above Rs.999/-(Assesseble Value)"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'1', 0);
	$this->Cell(100, 15, " "." ",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(175, 15, "B.E.D. 2% ON 60% OF MRP VALUE"." ",'1', 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(100, 15, " "." ",'1', 0);
	$this->Cell(100, 15, " "." ",'1', 1);
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(100, 15, "Total Excise Amount In Rupees:"." ",'LT', 0);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(470, 15,"($billdet_res_row[quotcurr])  ".$_POST['tword'],'RT');
	$this->SetFont('Arial', '');
	
	$this->SetFont('Arial', '');
	$this->Cell(100, 15, "Total Invoice Value in Rupees:"." ",'LB', 0);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(470, 15,"($billdet_res_row[quotcurr])  ".$_POST['tword'],'RB');
	
	
	$this->SetFont('Arial', '');
	$this->Cell(570, 13, "* Vide notification no 15/2016 dated 01.03.2016, excise is charged on the goodes having MRP above/equals to Rs.1000/-."." ",'LR', 1);
	
	$this->SetFont('Arial', '');
	$this->MultiCell(570, 10,"Excise Declaration: I/We hereby declare to the best of our knowledge and belief that the particulars stated herein are true and correct and there is no additional consideration accuring to us either or indirectly in any manner other than the amounts indicated here ",'LRB');
	
	
	$term=$this->GetY();
	$this->SetFont('Arial', '');
	$this->MultiCell(285, 9," + Tems & Conditions +
	* Payment for this bill will be accepted only by cross & order draft or cheque only.
	* Goods once sold will be not be taken back.
	* Payment strictly within 30 Days",'LB');
	
	$this->SetXY(295,$term);
	$this->SetFont('Arial', 'B');
	$this->MultiCell(285, 9," Our Bankers : ICICI Bank
	Branch Name : Malad(West), Mumbai
	A/C No. 015805001010
	RTGS/NEFT IFSC : ICIC0000158",'RB', 'C');
	
    $this->SetFont('Arial', 'B', 6);
	$this->MultiCell(570, 6,"Any Disputes or Differences whatsoever arising between the parties relating to this contract shall be subject to jurisdiction of conciliation & arbitration Sub committee for settlement in accordance with rules for conciliation of The clothing manufacturers Association of India and if not Resolved then shall be referred to Arbitration in accordance with the Rules of arbitration of the Indian Merchant Chambers as per MOU between CMAI & IMC and award made in pursuance there of shall be Final and binding on the  parties.\"
	
	\"I/We hereby certify that my/our registration certificate under the Maharashtra Value Added Tax Act 2002 is in Force on the date on which the sale of the goods specified in this tax invoice is made by me/us and that the transaction of sale covered by this tax invoice has been effected by me/us and it is shall be accounted for in turnover of sales while filling of return and the due tax, if any payable on the sale has been paid or shall be paid.\"",'LRB');
	
	
	
	
	
	$t=$this->GetY();
	
	
	$this->SetXY(430,$y);
		
	$this->Cell(50, 15, "Total",0, 0);
	$this->Cell(50, 15, "",0, 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row['total'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	
	
	if(!empty($billdet_res_row['disa'])&&$billdet_res_row['disa']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "Discount:", 0);
	$this->Cell(50, 15,$billdet_res_row['disr']."%", 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15, $billdet_res_row['disa'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}
	
	if(!empty($billdet_res_row['vata'])&&$billdet_res_row['vata']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "Vat", 0);
	$this->Cell(50, 15, $billdet_res_row['vatr']."%", 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row['vata'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}
	
	if(!empty($billdet_res_row['sevta'])&&$billdet_res_row['sevta']!='0.00'){
	$this->SetX(430);
	$this->Cell(50, 15, "SevT", 0);
	$this->Cell(50, 15, $billdet_res_row['sevtr']."%", 0);
	$this->SetFont('Arial', 'B');
	$this->Cell(50, 15,  $billdet_res_row['sevta'], 0, 1, 'R');
	$this->SetFont('Arial', '');
	}

	if(!empty($billdet_res_row['extraa'])&&$billdet_res_row['extraa']!='0.00'){
		$this->SetX(430);
		$this->Cell(50, 15, $billdet_res_row['extra'], 0);
		$this->Cell(50, 15, $billdet_res_row['extrar']."%", 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(50, 15, $billdet_res_row['extraa'], 0, 1, 'R');
		$this->SetFont('Arial', '');
		}
		
		$this->SetX(430);
		$this->Cell(50, 15, "Grand Total",'TB', 0);
		$this->Cell(50, 15, "",'TB', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(50, 15, $billdet_res_row['gtotal'], 'TB', 1, 'R');
		$this->SetFont('Arial', '');

		$this->SetFont('Arial', '',7);
		$this->SetY($t);
		$t=$this->GetY();
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "VAT TIN No.:",'TL', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(200, 15, "27740027477V .w.e.f.01.04.2006",'', 0);
		$this->Cell(130, 15, " ",'', 0);
		$this->Cell(170, 15, "From $_SESSION[SESS_CMP]",'LR', 1);
		$this->SetFont('Arial', '');
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "CST TIN No.:",'L', 0);
		$this->SetFont('Arial', 'B');
		$this->Cell(200, 15, "27740027477VC w.e.f.01.04.2006",'', 0);
		$this->Cell(130, 15, " ",'', 0);
		$this->Cell(170, 15, " ",'LR', 1);
		
		
		$this->SetFont('Arial', '');
		$this->Cell(70, 15, "CIN No.",'BL', 0);
		$this->SetFont('Arial', '',7);
		$this->Cell(200, 15, " ",'B', 0);
		$this->Cell(130, 15, "Receiver Signature [With Rubber Stamp]",'TB','C', 0);
		$this->SetFont('Arial', '',8);
		$this->Cell(170, 15, "Authorised Signatory.",'LBR', 1);
		$this->SetFont('Arial', '');
		
		//$this->SetY($t+10);
		
	$this->make_border($start_border,$end_border);
		
	}// end of bill_footer()


	
	function make_border($start_border,$end_border)
	{
		$this->Line(10,$start_border,580,$start_border);
			//$this->Line(16,$start_border,584,$start_border);
			
			
			$this->Line(10,$start_border,10,$end_border-5); 
			//$this->Line(16,$start_border,16,$end_border); 
			
			
			$this->Line(580,$start_border,580,$end_border-5);
			//$this->Line(586,$start_border,586,$end_border);
			
			$this->Line(10,$end_border-5,580,$end_border-5);
			//$this->Line(10,$end_border,586,$end_border);
		}

}//end of class


$pdf = new PDF_result();
$pdf->AddPage();


$billno=$_POST['jobid'];
	include '../../db_connect.php';
	//to select the company's table in current session
include '../../db_table_select.php';

$billSql = "SELECT `orderid`,   DATE_FORMAT(`orderdate`,'%d/%m/%Y') as `orderdate`, `ordertype`, `buyercode`, `billedto`, `refno`,  DATE_FORMAT(`dlvdate`,'%d/%m/%Y') as `dlvdate`, `ratetype`, `shipto`, `agentcode`, `distr`, `shipvia`, `shippingpaid`, `comm`, `comm_on`, `notes`, `packinglistno`, `ptotal`, `pdiscount`, `pnamount`, `grtotal`, `status` FROM  sinvoicereg INNER JOIN commst ON buyercode=compid  WHERE orderid = '$billno'";
echo $billSql;
$billdet_res=mysqli_query($con,$billSql);

$billdet_res_row=mysqli_fetch_assoc($billdet_res);
$pdf->SetFont('Arial', 'B', 10);
$pdf->bill_header($billdet_res_row,$con);
$pdf->Generate_Table($billdet_res_row,$con);	
$pdf->Output('job_entry.pdf', 'F');



?>
