(function($) {
    $.fn.createScrollableTable = function(options) {
		
        var defaults = {
            width: '400px',
            height: '300px',
            border: '',
			
        };
        var options = $.extend(defaults, options);
		
		

        return this.each(function() {
            var table = $(this);
            prepareTable(table);
        });
		

        function prepareTable(table) {
			
			var adjustment=table.attr('width');
		if(isNaN(adjustment))
		adjustment='98.7%';
            var tableId = table.attr('id');

            // wrap the current table (will end up being just body table)
            var bodyWrap = table.wrap('<div></div>')
                                    .parent()
                                    .attr('id', tableId + '_body_wrap')
                                    .css({
                                        width: Number(table.attr('width'))+20,
                                        height: options.height,
                                        'overflow-y': 'scroll',
										'overflow-x': 'hidden'
                                    });

            // wrap the body
            var tableWrap = bodyWrap.wrap('<div></div>')
                                    .parent()
                                    .attr('id', tableId + '_table_wrap')
                                    .css({
										width: options.width,
                                        overflow: 'auto',
                                        display: 'inline-block',
                                        border: options.border
                                    });

            // clone the header
            var headWrap = $(document.createElement('div'))
                                    .attr('Id', tableId + '_head_wrap')
                                    .prependTo(tableWrap)
                                    .css({
                                      //  width: options.hwidth,
                                       // overflow: 'auto'
                                    });

            var headTable = table.clone(true)
                                    .attr('Id', tableId + '_head')
                                    .appendTo(headWrap)
                                    .css({
                                        'table-layout': 'fixed',
										'width': adjustment
                                    });
//
//            var bufferCol = $(document.createElement('th'))
//                                    .css({
//                                       // width: '100%'
//                                    })
//                                    .appendTo(headTable.find('thead tr'));

            // remove the extra html
            headTable.find('tbody').remove();
            table.find('thead').remove();

            // size the header columns to match the body
            var allBodyCols = table.find('tbody tr:first td');
            headTable.find('thead tr th').each(function(index) {
                var desiredWidth = getWidth($(allBodyCols[index]));
                $(this).css({  });
            });
        }

        function getWidth(td) {
            if ($.browser.msie) { return $(td).outerWidth() - 1; }
            if ($.browser.mozilla) { return $(td).width(); }
            if ($.browser.safari) { return $(td).outerWidth(); }
            return $(td).outerWidth();
        };

    };

})(jQuery);